include ("mt\\purgeNGS.cs");

function RetOver::setUpBmps (%gui)
{
	echo ("RetOver::setUpBmps ("@%gui@")");
	purgeNGSof ("reticle_over");
	if (%gui==PlayGui)
		{
		// For some reason, the event isn't detached properly, even though it says it does :(
		Event::Detach(eventGuiOpen, RetOver::setUpBmps);
		$reticleOverlayGui=loadObject ("Reticle_overlaysGui", "mt\\gui\\"@$pref::VideoFullScreenRes@"\\Reticle_overlays.gui");
		addToSet (PlayGui, $reticleOverlayGui);
		control::setVisible ("Disc_reticle_overlay", true);
		control::setVisible ("Plasma_reticle_overlay", false);
		$currentOverlay=$currentWeapon=21;
		echo ("$reticleOverlayGui is "@$reticleOverlayGui);
		RetOver::heartbeat ();
		RetOver::cleanupHeartbeat ();
		}
	return;
}

function RetOver::heartbeat ()
{
	schedule ("RetOver::heartbeat ();", 0.2);
	%weapon=getMountedItem (0);
	if (%weapon!=$currentWeapon)
		{
		control::setVisible ($overlay[$currentOverlay], False);
		$currentWeapon=%weapon;
		$currentOverlay=%Weapon@$alt;
		control::setVisible ($overlay[$currentOverlay], True);
		}
	if ($animate::[%weapon] && !$Animating)
		{
		$Animating=True;
		RetOver::animateReticle ();
		}
	else if (!$animate::[%weapon] && $Animating)
		{
		$Animating=False;
		%frame= "Animate"@$anim@"_reticle_overlay";
		control::setVisible (%frame, false);
		$anim=4;
		}
}

function RetOver::cleanupHeartbeat ()
{
	schedule ("RetOver::cleanupHeartbeat ();",5);
	%weapon=getMountedItem (0);
	for (%i=11;%i<=25;%i++)
		{
		control::setVisible ($overlay[%i], (%i==%weapon && $alt==""));
		control::setVisible ($overlay[%i@"_alt"], (%i==%weapon && $alt!=""));
		}
}

function RetOver::altOverlays ()
{
	control::setVisible ($overlay[$currentOverlay], False);
	if ($alt=="")
		{
		$alt="_alt";
		$currentOverlay=$currentOverlay@"_alt";
		}
	else
		{
		$alt="";
		$currentOverlay=$currentWeapon;
		}
	control::setVisible ($overlay[$currentOverlay], True);
}

function RetOver::animateReticle ()
{
	if (!$Animating)
		return;

	schedule ("RetOver::animateReticle (False);", 0.5);
	%anim=$anim;
	$anim++;
	if ($anim>=5)
		$anim=1;

	echo ($anim);
	%oldFrame= "Animate"@%anim@"_reticle_overlay";
	%newFrame= "Animate"@$anim@"_reticle_overlay";
	control::setVisible (%oldframe, false);
	control::setVisible (%newframe, true);
	
}

function setTags (%tag, %num, %bmp)
{
	%res=$pref::VideoFullScreenRes;
	%exists=isFile ("config\\mt\\bmps\\"@%res@"\\"@%bmp);
	if (%exists)
		{
		%str=%tag@"="@%num@", \"mt\\\\bmps\\\\"@%res@"\\\\"@%bmp@"\";";
		//echo (%str);
		eval (%str);
		}
	else
		{
		%str=%tag@"="@%num@", \"mt\\\\bmps\\\\default\\\\"@%bmp@"\";";
		eval (%str);
		}
}

function RetOver::newOptsInit ()
{
	NewOpts::registerHelp("Reticle Overlays", "Default Crosshairs",
	"The crosshairs for <f2>Reticle Overlays<f1> are all 8 bit Windows bitmaps. They are located in the"@
	" mt\\bmps\\default directory and can be edited with any suitable image editor. They must be 256x256"@
	" pixels large, with centers of 128x128. Editing the default crosshairs will affect all of the resolutions"@
	" whereas editing a bitmap and then saving it to the directory for a particular resolution (ie put bitmaps"@
	" for 1024x768 in the mt\\bmps\\1024x768 directory) will only work at a single resolution. ");
	NewOpts::registerHelp("Reticle Overlays", "", "This means that"@
	" you can make crosshairs for something like the chaingun that are accurate at all resolutions. However, the"@
	" field of view can also affect the accuracy of, as can the position of the weapon you're holding (the Presto"@
	" pack alters this so the default chaingun crosshair may not be 100% accurate). With so many different variables"@
	" you just have to try and match things as best you can.");
	NewOpts::registerHelp("Reticle Overlays", "Animation",
	"The tick boxes on the <f2>NewOpts Reticle Overlays<f1> page control which crosshairs will be animated."@
	"You don't have to stick with the default ones, or with the default animation. Like all of the bitmaps"@
	"that are used for the crosshairs, the animation is simply four 8 bit bitmaps that can be fiddled by any"@
	"image editor available. If you use the palettes that are available with the <f2>Volumer<f1> tool, then"@
	"the animations (or crosshairs) will change colour according to what map is being played at the time");
	NewOpts::register("Reticle Overlays", "mt\\gui\\ReticleOverlaysNewOpts.gui", "RetOver::newOptsOpen ();", "RetOver::newOptsClose ();", true);
}

function RetOver::newOptsOpen ()
{
	echo ("function RetOver::newOptsOpen ();");
	control::setValue ("ReticleOverlaysAnimateBlasterButton",$animate::[11]);
	control::setValue ("ReticleOverlaysAnimatePlasmaButton",$animate::[17]);
	control::setValue ("ReticleOverlaysAnimateChaingunButton",$animate::[13]);
	control::setValue ("ReticleOverlaysAnimateDiscButton",$animate::[21]);
	control::setValue ("ReticleOverlaysAnimateGrenadeButton",$animate::[17]);
	control::setValue ("ReticleOverlaysAnimateLaserButton",$animate::[22]);
	control::setValue ("ReticleOverlaysAnimateElfButton",$animate::[24]);
	control::setValue ("ReticleOverlaysAnimateMortarButton",$animate::[19]);
	control::setValue ("ReticleOverlaysAnimateTargetButton",$animate::[23]);
	control::setValue ("ReticleOverlaysAnimateRepairButton",$animate::[25]);
}

function RetOvers::exportPrefs ()
{
	purgeNGSof ("reticle_over");
	export ("$animate::*", "config\\ReticleOverlaysPrefs.cs", False);
}

setTags ("IDBMP_RETICLE_BLASTER", "00160951", "blaster_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_PLASMA", "00160952", "plasma_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_CHAINGUN", "00160953", "chaingun_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_DISC", "00160954", "disc_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_GRENADE", "00160955", "grenade_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_LASER", "00160956", "laser_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_ELF", "00160957", "elf_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_MORTAR", "00160958", "mortar_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_TARGET", "00160959", "target_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_REPAIR", "00160960", "repair_reticle_overlay.bmp"); 

setTags ("IDBMP_RETICLE_BLASTER_ALT", "00160961", "blaster_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_PLASMA_ALT", "00160962", "plasma_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_CHAINGUN_ALT", "00160963", "chaingun_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_DISC_ALT", "00160964", "disc_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_GRENADE_ALT", "00160965", "grenade_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_LASER_ALT", "00160966", "laser_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_ELF_ALT", "00160967", "elf_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_MORTAR_ALT", "00160968", "mortar_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_TARGET_ALT", "00160969", "target_reticle_overlay_alt.bmp"); 
setTags ("IDBMP_RETICLE_REPAIR_ALT", "00160970", "repair_reticle_overlay_alt.bmp"); 

setTags ("IDBMP_RETICLE_ANIMATE1_ALT", "00160971", "animate1_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_ANIMATE2_ALT", "00160972", "animate2_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_ANIMATE3_ALT", "00160973", "animate3_reticle_overlay.bmp"); 
setTags ("IDBMP_RETICLE_ANIMATE4_ALT", "00160974", "animate4_reticle_overlay.bmp"); 

$overlay["11"]="Blaster_reticle_overlay";
$overlay["13"]="Chaingun_reticle_overlay";
$overlay["15"]="Plasma_reticle_overlay";
$overlay["17"]="Grenade_reticle_overlay";
$overlay["19"]="Mortar_reticle_overlay";
$overlay["21"]="Disc_reticle_overlay";
$overlay["22"]="Laser_reticle_overlay";
$overlay["23"]="Target_reticle_overlay";
$overlay["24"]="Elf_reticle_overlay";
$overlay["25"]="Repair_reticle_overlay";

$overlay["11_alt"]="Blaster_reticle_overlay_alt";
$overlay["13_alt"]="Chaingun_reticle_overlay_alt";
$overlay["15_alt"]="Plasma_reticle_overlay_alt";
$overlay["17_alt"]="Grenade_reticle_overlay_alt";
$overlay["19_alt"]="Mortar_reticle_overlay_alt";
$overlay["21_alt"]="Disc_reticle_overlay_alt";
$overlay["22_alt"]="Laser_reticle_overlay_alt";
$overlay["23_alt"]="Target_reticle_overlay_alt";
$overlay["24_alt"]="Elf_reticle_overlay_alt";
$overlay["25_alt"]="Repair_reticle_overlay_alt";

//You can set the animated crosshairs here or using NewOpts or by editing the
//ReticleOverlaysPrefs.cs file in the tribes/config directory
if (!isFile ("config\\ReticleOverlaysPrefs.cs"))
	{
	$animate::["11"]=false;
	$animate::["13"]=false;
	$animate::["15"]=false;
	$animate::["17"]=false;
	$animate::["19"]=false;
	$animate::["21"]=false;
	$animate::["22"]=false;
	$animate::["23"]=True;
	$animate::["24"]=True;
	$animate::["25"]=True;
	}
else
	exec ("ReticleOverlaysPrefs.cs");

$Animating=False;
$anim=0;

event::attach(eventGuiOpen, RetOver::setUpBmps, %gui);
event::attach(eventExit, RetOvers::exportPrefs);

if ($Presto::version >= 0.93)
	Presto::AddScriptBanner(NewOpts, "\n<f2><jc>Reticle Overlays\n\n<f0><jc>(beta 1.0)\n\n<f1><jc>By Shane \"Mental Trousers\" Taylor\n\n<f0><jc>mentaltrousers@planetstarsiege.com");

if ($NewOpts::regCount!="")
	RetOver::newOptsInit ();
else
	{
	EditActionMap("playMap.sae");
	bindCommand(keyboard0, make, "z", TO, "RetOver::altOverlays();");
	}