/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.CompoundCommand;
import tim.prune.cmd.ConnectMediaCmd;
import tim.prune.cmd.DeletePointCmd;
import tim.prune.cmd.RemoveAudioCmd;
import tim.prune.cmd.RemovePhotoCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.function.media.PopupResponse;

public class RemoveAudioFunction
extends GenericFunction {
    public RemoveAudioFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.removeaudio";
    }

    @Override
    public void begin() {
        Command command;
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        if (audioClip == null) {
            return;
        }
        RemoveAudioCmd removeAudioCmd = new RemoveAudioCmd(this._app.getTrackInfo().getSelection().getCurrentAudioIndex());
        DataPoint dataPoint = audioClip.getDataPoint();
        switch (this.shouldDeletePoint(audioClip)) {
            default: {
                return;
            }
            case MEDIA_NOT_CONNECTED: {
                command = removeAudioCmd;
                break;
            }
            case UNLINK: {
                command = new CompoundCommand().addCommand(removeAudioCmd).addCommand(new ConnectMediaCmd(dataPoint, dataPoint.getPhoto(), null));
                break;
            }
            case DELETE: {
                command = new CompoundCommand().addCommand(removeAudioCmd).addCommand(new DeletePointCmd(this._app.getTrackInfo().getSelection().getCurrentPointIndex())).addCommand(dataPoint == null || dataPoint.getPhoto() == null ? null : new RemovePhotoCmd(this._app.getTrackInfo().getSelection().getCurrentPhotoIndex()));
            }
        }
        command.setDescription(I18nManager.getText("undo.removeaudio", audioClip.getName()));
        command.setConfirmText(I18nManager.getText("confirm.media.removed", audioClip.getName()));
        this._app.execute(command);
    }

    private PopupResponse shouldDeletePoint(AudioClip audioClip) {
        DataPoint dataPoint = audioClip.getDataPoint();
        if (dataPoint == null) {
            return PopupResponse.MEDIA_NOT_CONNECTED;
        }
        boolean bl = dataPoint.getPhoto() != null;
        String string = bl ? I18nManager.getText("dialog.deleteaudio.deletepointandphoto", dataPoint.getPhoto().getName()) : I18nManager.getText("dialog.deleteaudio.deletepoint");
        int n = JOptionPane.showConfirmDialog(this._app.getFrame(), string, I18nManager.getText("dialog.deleteaudio.title"), 1);
        if (n == 2 || n == -1) {
            return PopupResponse.CANCEL;
        }
        return n == 0 ? PopupResponse.DELETE : PopupResponse.UNLINK;
    }
}

