/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.NumberUtils;
import tim.prune.data.Track;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.function.charts.ChartSeries;
import tim.prune.function.comparesegments.DataPanel;
import tim.prune.function.comparesegments.IntersectionResult;
import tim.prune.function.comparesegments.MatchesPanel;
import tim.prune.function.comparesegments.PointData;
import tim.prune.function.comparesegments.SegmentData;
import tim.prune.function.comparesegments.SegmentLooper;
import tim.prune.function.comparesegments.SegmentSummary;
import tim.prune.function.comparesegments.SegmentTableModel;
import tim.prune.function.comparesegments.SegmentsPanel;
import tim.prune.gui.BoxPanel;
import tim.prune.gui.WizardLayout;

public class CompareSegmentsFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private WizardLayout _wizard = null;
    private JLabel _topLabel = null;
    private JTable _segmentTable = null;
    private SegmentTableModel _segmentModel = null;
    private JButton _compareButton = null;
    private JButton _exportButton = null;
    private JButton _chartButton = null;
    private Integer _lastSelectedSegment = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;
    private final ArrayList<IntersectionResult> _results = new ArrayList();
    private SegmentsPanel _segmentsPanel = null;
    private MatchesPanel _matchesPanel = null;
    private DataPanel _dataPanel = null;

    public CompareSegmentsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.comparesegments";
    }

    @Override
    public void begin() {
        ArrayList<SegmentSummary> arrayList = this.makeSegmentList(this._app.getTrackInfo().getTrack());
        if (arrayList.size() < 2) {
            this._app.showErrorMessage(this.getNameKey(), "error.comparesegments.needtwosegments");
            return;
        }
        if (this._dialog == null) {
            this._segmentModel = new SegmentTableModel();
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    CompareSegmentsFunction.this._cancelled = true;
                }
            });
            this._dialog.pack();
        }
        TimeZone timeZone = TimezoneHelper.getSelectedTimezone(this.getConfig());
        Unit unit = this.getConfig().getUnitSet().getDistanceUnit();
        this._segmentModel.init(arrayList, timeZone, unit);
        this._segmentTable.clearSelection();
        this._segmentTable.getColumnModel().getColumn(2).setCellRenderer(new RightPaddedRenderer());
        this._compareButton.setEnabled(arrayList.size() == 2);
        this.setDialogTitle(arrayList.size() == 2);
        if (arrayList.size() == 2) {
            this._segmentTable.addRowSelectionInterval(0, 1);
        }
        this._wizard.showFirstCard();
        this._cancelled = false;
        this._dialog.setVisible(true);
    }

    private void setDialogTitle(boolean bl) {
        String string = bl ? "dialog.comparesegments.introtwosegments" : "dialog.comparesegments.intro";
        this._topLabel.setText(I18nManager.getText(string));
    }

    private ArrayList<SegmentSummary> makeSegmentList(Track track) {
        ArrayList<SegmentSummary> arrayList = new ArrayList<SegmentSummary>();
        SegmentSummary segmentSummary = null;
        int n = 0;
        while (n < track.getNumPoints()) {
            DataPoint dataPoint = track.getPoint(n);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                if (segmentSummary == null) {
                    segmentSummary = new SegmentSummary(n, dataPoint);
                } else if (dataPoint.getSegmentStart()) {
                    if (segmentSummary.isValid()) {
                        arrayList.add(segmentSummary);
                    }
                    segmentSummary = new SegmentSummary(n, dataPoint);
                } else {
                    segmentSummary.addPoint(dataPoint);
                }
            }
            ++n;
        }
        if (segmentSummary != null && segmentSummary.isValid()) {
            arrayList.add(segmentSummary);
        }
        return arrayList;
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        this._wizard = new WizardLayout(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 5));
        this._topLabel = new JLabel(I18nManager.getText("dialog.comparesegments.intro"));
        this._topLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)this._topLabel, "North");
        this._segmentTable = new JTable(this._segmentModel);
        this._segmentTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.checkSelection());
        this._segmentTable.setRowSelectionAllowed(true);
        this._segmentTable.setSelectionMode(2);
        this._segmentTable.setAutoCreateRowSorter(true);
        JScrollPane jScrollPane = new JScrollPane(this._segmentTable);
        jScrollPane.setPreferredSize(new Dimension(400, 250));
        jPanel2.add((Component)jScrollPane, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    CompareSegmentsFunction.this._dialog.dispose();
                }
            }
        };
        this._segmentTable.addKeyListener(keyAdapter);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._compareButton = new JButton(I18nManager.getText("button.compareselected"));
        this._compareButton.addActionListener(actionEvent -> this.doCompare());
        jPanel3.add(this._compareButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(5, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(Box.createVerticalGlue());
        jPanel5.add(new JLabel(I18nManager.getText("dialog.comparesegments.comparing")));
        this._progressBar = new JProgressBar(0, 200);
        this._progressBar.setIndeterminate(true);
        this._progressBar.setStringPainted(true);
        jPanel5.add(this._progressBar);
        jPanel5.add(Box.createVerticalGlue());
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(jButton);
        jPanel4.add((Component)jPanel5, "Center");
        jPanel4.add((Component)jPanel3, "South");
        BoxPanel boxPanel = BoxPanel.create();
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.comparesegments.results"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        boxPanel.add(jLabel);
        boxPanel.add(Box.createVerticalStrut(4));
        this._segmentsPanel = new SegmentsPanel();
        boxPanel.add(this._segmentsPanel);
        this._matchesPanel = new MatchesPanel();
        boxPanel.add(this._matchesPanel);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._exportButton = new JButton(I18nManager.getText("button.exportdata"));
        this._exportButton.addActionListener(actionEvent -> this._wizard.showNextCard());
        jPanel3.add(this._exportButton);
        this._chartButton = new JButton(I18nManager.getText("button.chart"));
        this._chartButton.addActionListener(actionEvent -> this.showChart(this._results));
        jPanel3.add(this._chartButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.close"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton2);
        boxPanel.add(jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        this._dataPanel = new DataPanel();
        jPanel6.add((Component)this._dataPanel, "Center");
        jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JButton jButton3 = new JButton(I18nManager.getText("button.back"));
        jButton3.addActionListener(actionEvent -> this._wizard.showPreviousCard());
        jPanel3.add(jButton3);
        jPanel6.add((Component)jPanel3, "South");
        this._wizard.addCard(jPanel2);
        this._wizard.addCard(jPanel4);
        this._wizard.addCard(boxPanel);
        this._wizard.addCard(jPanel6);
        return jPanel;
    }

    private void checkSelection() {
        int n = this._segmentTable.getSelectedRowCount();
        this._compareButton.setEnabled(n == 2);
        if (n == 1 && this._lastSelectedSegment != null && this._lastSelectedSegment.intValue() != this._segmentTable.getSelectedRow()) {
            this._segmentTable.addRowSelectionInterval(this._lastSelectedSegment, this._lastSelectedSegment);
        }
        this._lastSelectedSegment = n == 1 ? Integer.valueOf(this._segmentTable.getSelectedRow()) : null;
    }

    private void doCompare() {
        int n;
        if (this._segmentTable.getSelectedRowCount() != 2) {
            return;
        }
        Integer n2 = null;
        Integer n3 = null;
        int n4 = 0;
        while (n4 < this._segmentTable.getRowCount()) {
            if (this._segmentTable.isRowSelected(n4)) {
                n = this._segmentTable.convertRowIndexToModel(n4);
                if (n2 == null) {
                    n2 = n;
                    n3 = n;
                } else {
                    n2 = Math.min(n2, n);
                    n3 = Math.max(n3, n);
                }
            }
            ++n4;
        }
        if (n2 == null || n3 == null || n3.equals(n2)) {
            throw new IllegalArgumentException("Require exactly two segments to be selected");
        }
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
        this._wizard.showNextCard();
        n4 = n2;
        n = n3;
        new Thread(() -> this.doCompareAsync(n4, n)).start();
    }

    private void doCompareAsync(int n, int n2) {
        int n3 = this._segmentModel.getSegmentStartIndex(n);
        int n4 = this._segmentModel.getSegmentStartIndex(n2);
        this._results.clear();
        this.findIntersections(this._results, n3, n4);
        this._wizard.showNextCard();
        boolean bl = this._results.size() >= 2;
        this._exportButton.setEnabled(bl);
        this._chartButton.setEnabled(bl);
        if (!bl) {
            System.err.println("Couldn't find enough intersections for the comparison");
            this._app.showErrorMessage(this.getNameKey(), "error.comparesegments.notenoughintersections");
        }
    }

    private void findIntersections(ArrayList<IntersectionResult> arrayList, int n, int n2) {
        SegmentData segmentData;
        ProgressWidget progressWidget = new ProgressWidget();
        SegmentData segmentData2 = new SegmentData(this._app.getTrackInfo().getTrack(), n);
        boolean bl = segmentData2.isBefore(segmentData = new SegmentData(this._app.getTrackInfo().getTrack(), n2));
        SegmentData segmentData3 = bl ? segmentData2 : segmentData;
        SegmentData segmentData4 = bl ? segmentData : segmentData2;
        this._segmentsPanel.setDetails(segmentData3, segmentData4, this.getConfig());
        arrayList.clear();
        this.findIntersections(segmentData3, segmentData4, arrayList, false, progressWidget);
        this.findIntersections(segmentData4, segmentData3, arrayList, true, progressWidget);
        Collections.sort(arrayList);
        this._matchesPanel.setDetails(arrayList, this.getConfig());
        this._dataPanel.setDetails(arrayList, this.getConfig());
    }

    private void findIntersections(SegmentData segmentData, SegmentData segmentData2, ArrayList<IntersectionResult> arrayList, boolean bl, ProgressWidget progressWidget) {
        SegmentLooper segmentLooper = new SegmentLooper(segmentData2.getLines());
        int n = segmentData.getPoints().getNumPoints();
        int n2 = 0;
        for (PointData pointData : segmentData.getPoints().getPoints()) {
            IntersectionResult intersectionResult = segmentLooper.match(pointData);
            if (intersectionResult != null) {
                arrayList.add(bl ? intersectionResult.reverse() : intersectionResult);
            }
            progressWidget.showProgress(n2, n);
            ++n2;
            if (!this._cancelled) continue;
            return;
        }
    }

    private void showChart(ArrayList<IntersectionResult> arrayList) {
        if (!ExternalTools.isToolInstalled(this.getConfig(), 2)) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.charts.gnuplotnotfound");
            return;
        }
        String string = this.getConfig().getConfigString("prune.gnuplotpath");
        try {
            Process process = Runtime.getRuntime().exec(String.valueOf(string) + " -persist");
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(process.getOutputStream());){
                outputStreamWriter.write("set multiplot layout 3,1\n");
                outputStreamWriter.write("set origin 0,0\n");
                outputStreamWriter.write("set size 1,0.25\n");
                this.writeAltitudeChart(outputStreamWriter, arrayList);
                outputStreamWriter.write("set origin 0,0.25\n");
                outputStreamWriter.write("set size 1,0.375\n");
                this.writeTimeAheadChart(outputStreamWriter, arrayList);
                outputStreamWriter.write("set origin 0,0.625\n");
                outputStreamWriter.write("set size 1,0.375\n");
                this.writeSpeedIncreaseChart(outputStreamWriter, arrayList);
                outputStreamWriter.write("unset multiplot\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to execute Gnuplot: " + iOException.getMessage());
        }
    }

    private void writeAltitudeChart(OutputStreamWriter outputStreamWriter, ArrayList<IntersectionResult> arrayList) throws IOException {
        ChartSeries chartSeries = this.getDistanceValues(arrayList);
        ChartSeries chartSeries2 = this.getAltitudeValues(arrayList);
        File file = File.createTempFile("gpsprunedata", null);
        file.deleteOnExit();
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("# Temporary data file for GpsPrune charts\n\n");
            int n = 0;
            while (n < arrayList.size()) {
                if (chartSeries.hasData(n) && chartSeries2.hasData(n)) {
                    fileWriter.write(chartSeries.getData(n) + ", " + chartSeries2.getData(n) + "\n");
                }
                ++n;
            }
            UnitSet unitSet = this.getConfig().getUnitSet();
            String string = I18nManager.getText(unitSet.getDistanceUnit().getShortnameKey());
            outputStreamWriter.write("set xlabel '" + I18nManager.getText("fieldname.distance") + " (" + string + ")'\n");
            String string2 = I18nManager.getText(unitSet.getAltitudeUnit().getShortnameKey());
            outputStreamWriter.write("set ylabel '" + I18nManager.getText("fieldname.altitude") + " (" + string2 + ")'\n");
            outputStreamWriter.write("set style fill solid 0.5 border -1\n");
            double d = this.getMinAltitude(chartSeries2);
            outputStreamWriter.write("plot '" + file.getAbsolutePath() + "' title '' with filledcurve y1=" + d + " lt rgb \"#009000\"\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private double getMinAltitude(ChartSeries chartSeries) {
        double d = 0.0;
        boolean bl = false;
        int n = 0;
        while (n < chartSeries.getNumPoints()) {
            double d2;
            if (chartSeries.hasData(n) && (d > (d2 = chartSeries.getData(n)) || !bl)) {
                d = d2;
                bl = true;
            }
            ++n;
        }
        return Math.floor(d / 10.0) * 10.0;
    }

    private ChartSeries getDistanceValues(ArrayList<IntersectionResult> arrayList) {
        ChartSeries chartSeries = new ChartSeries(arrayList.size());
        IntersectionResult intersectionResult = null;
        Unit unit = this.getConfig().getUnitSet().getDistanceUnit();
        int n = 0;
        for (IntersectionResult intersectionResult2 : arrayList) {
            double d;
            if (intersectionResult == null) {
                d = 0.0;
                intersectionResult = intersectionResult2;
            } else {
                d = intersectionResult2.getFirstDistanceRadians(intersectionResult);
            }
            chartSeries.setData(n, Distance.convertRadiansToDistance(d, unit));
            ++n;
        }
        return chartSeries;
    }

    private ChartSeries getAltitudeValues(ArrayList<IntersectionResult> arrayList) {
        ChartSeries chartSeries = new ChartSeries(arrayList.size());
        Unit unit = this.getConfig().getUnitSet().getAltitudeUnit();
        int n = 0;
        for (IntersectionResult intersectionResult : arrayList) {
            double d = intersectionResult.getFirstPoint().getAltitude().getValue(unit);
            chartSeries.setData(n, d);
            ++n;
        }
        return chartSeries;
    }

    private void writeTimeAheadChart(OutputStreamWriter outputStreamWriter, ArrayList<IntersectionResult> arrayList) throws IOException {
        ChartSeries chartSeries = this.getDistanceValues(arrayList);
        ChartSeries chartSeries2 = this.getTimeValues(arrayList);
        File file = File.createTempFile("gpsprunedata", null);
        file.deleteOnExit();
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("# Temporary data file for GpsPrune charts\n\n");
            int n = 0;
            while (n < arrayList.size()) {
                if (chartSeries.hasData(n) && chartSeries2.hasData(n)) {
                    fileWriter.write(chartSeries.getData(n) + ", " + chartSeries2.getData(n) + "\n");
                }
                ++n;
            }
            outputStreamWriter.write("set grid\n");
            outputStreamWriter.write("set xlabel ''\n");
            String string = I18nManager.getText("dialog.comparesegments.data.secsahead");
            outputStreamWriter.write("set ylabel '" + string + "'\n");
            outputStreamWriter.write("set style fill solid 0.5 border -1\n");
            outputStreamWriter.write("plot '" + file.getAbsolutePath() + "' title '' with points lt rgb \"#009000\"\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ChartSeries getTimeValues(ArrayList<IntersectionResult> arrayList) {
        ChartSeries chartSeries = new ChartSeries(arrayList.size());
        int n = 0;
        IntersectionResult intersectionResult = null;
        for (IntersectionResult intersectionResult2 : arrayList) {
            long l;
            if (intersectionResult == null) {
                intersectionResult = intersectionResult2;
                l = 0L;
            } else {
                l = intersectionResult2.getFirstDurationSeconds(intersectionResult) - intersectionResult2.getSecondDurationSeconds(intersectionResult);
            }
            chartSeries.setData(n, l);
            ++n;
        }
        return chartSeries;
    }

    private void writeSpeedIncreaseChart(OutputStreamWriter outputStreamWriter, ArrayList<IntersectionResult> arrayList) throws IOException {
        ChartSeries chartSeries = this.getDistanceValues(arrayList);
        ChartSeries chartSeries2 = this.getSpeedValues(arrayList);
        File file = File.createTempFile("gpsprunedata", null);
        file.deleteOnExit();
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("# Temporary data file for GpsPrune charts\n\n");
            int n = 0;
            while (n < arrayList.size()) {
                if (chartSeries.hasData(n) && chartSeries2.hasData(n)) {
                    fileWriter.write(chartSeries.getData(n) + ", " + chartSeries2.getData(n) + "\n");
                }
                ++n;
            }
            outputStreamWriter.write("set grid\n");
            outputStreamWriter.write("set xlabel ''\n");
            Unit unit = this.getConfig().getUnitSet().getSpeedUnit();
            String string = String.valueOf(I18nManager.getText("dialog.comparesegments.data.speeddiff")) + " (" + I18nManager.getText(unit.getShortnameKey()) + ")";
            outputStreamWriter.write("set ylabel '" + string + "'\n");
            outputStreamWriter.write("set style fill solid 0.5 border -1\n");
            outputStreamWriter.write("plot '" + file.getAbsolutePath() + "' title '' with linespoints lt rgb \"#009000\"\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ChartSeries getSpeedValues(ArrayList<IntersectionResult> arrayList) {
        Unit unit = this.getConfig().getUnitSet().getDistanceUnit();
        ChartSeries chartSeries = new ChartSeries(arrayList.size());
        int n = 0;
        for (IntersectionResult intersectionResult : arrayList) {
            double d = intersectionResult.getDeltaSpeedRadiansPerSec();
            double d2 = Distance.convertRadiansToDistance(d, unit) * 60.0 * 60.0;
            chartSeries.setData(n, d2);
            ++n;
        }
        return chartSeries;
    }

    private class ProgressWidget {
        private int _lastIndex = 0;
        private int _toAdd = 0;

        private ProgressWidget() {
        }

        private void showProgress(int n, int n2) {
            if (n < this._lastIndex) {
                this._toAdd = 100;
            }
            int n3 = (int)(100.0 * (double)n / (double)n2);
            CompareSegmentsFunction.this._progressBar.setValue(n3 + this._toAdd);
            this._lastIndex = n;
        }
    }

    private static class RightPaddedRenderer
    extends DefaultTableCellRenderer {
        private RightPaddedRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 24));
            jLabel.setText(NumberUtils.formatNumberLocal((Double)object, 3));
            return jLabel;
        }
    }
}

