/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

A 2D or 3D edge detection using the Sobel operator.


This filter uses the Sobel operator to calculate the image gradient
and then finds the magnitude of this gradient vector. The Sobel
gradient magnitude (square-root sum of squares) is an indication of
edge strength.


See:
 ImageToImageFilter

 SobelOperator

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::SobelEdgeDetection for the procedural interface

 itk::SobelEdgeDetectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSobelEdgeDetectionImageFilter.h
*/
public class SobelEdgeDetectionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SobelEdgeDetectionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SobelEdgeDetectionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SobelEdgeDetectionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SobelEdgeDetectionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SobelEdgeDetectionImageFilter::~SobelEdgeDetectionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SobelEdgeDetectionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SobelEdgeDetectionImageFilter::SobelEdgeDetectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SobelEdgeDetectionImageFilter() {
    this(SimpleITKJNI.new_SobelEdgeDetectionImageFilter(), true);
  }

  /**
std::string itk::simple::SobelEdgeDetectionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SobelEdgeDetectionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SobelEdgeDetectionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SobelEdgeDetectionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SobelEdgeDetectionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SobelEdgeDetectionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
