/************************************************************************/
/*                                                                      */
/*               Copyright 1998-2008 by Ullrich Koethe                  */
/*                                                                      */
/*    This file is part of the VIGRA computer vision library.           */
/*    The VIGRA Website is                                              */
/*        http://hci.iwr.uni-heidelberg.de/vigra/                       */
/*    Please direct questions, bug reports, and contributions to        */
/*        ullrich.koethe@iwr.uni-heidelberg.de    or                    */
/*        vigra@informatik.uni-hamburg.de                               */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/


#ifndef VIGRA_PROMOTETRAITS_HXX
#define VIGRA_PROMOTETRAITS_HXX

// this file was autogenerated from promote_traits.hxx.py - DO NOT EDIT

template <>
struct PromoteTraits<bool, bool> : public detail::PromoteType<bool, bool>
{
    typedef detail::PromoteType<bool, bool>::Promote Promote;
    using detail::PromoteType<bool, bool>::toPromote;
};

template <>
struct PromoteTraits<bool, signed char> : public detail::PromoteType<bool, signed char>
{
    typedef detail::PromoteType<bool, signed char>::Promote Promote;
    using detail::PromoteType<bool, signed char>::toPromote;
};

template <>
struct PromoteTraits<bool, unsigned char> : public detail::PromoteType<bool, unsigned char>
{
    typedef detail::PromoteType<bool, unsigned char>::Promote Promote;
    using detail::PromoteType<bool, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<bool, short> : public detail::PromoteType<bool, short>
{
    typedef detail::PromoteType<bool, short>::Promote Promote;
    using detail::PromoteType<bool, short>::toPromote;
};

template <>
struct PromoteTraits<bool, unsigned short> : public detail::PromoteType<bool, unsigned short>
{
    typedef detail::PromoteType<bool, unsigned short>::Promote Promote;
    using detail::PromoteType<bool, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<bool, int> : public detail::PromoteType<bool, int>
{
    typedef detail::PromoteType<bool, int>::Promote Promote;
    using detail::PromoteType<bool, int>::toPromote;
};

template <>
struct PromoteTraits<bool, unsigned int> : public detail::PromoteType<bool, unsigned int>
{
    typedef detail::PromoteType<bool, unsigned int>::Promote Promote;
    using detail::PromoteType<bool, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<bool, long> : public detail::PromoteType<bool, long>
{
    typedef detail::PromoteType<bool, long>::Promote Promote;
    using detail::PromoteType<bool, long>::toPromote;
};

template <>
struct PromoteTraits<bool, unsigned long> : public detail::PromoteType<bool, unsigned long>
{
    typedef detail::PromoteType<bool, unsigned long>::Promote Promote;
    using detail::PromoteType<bool, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<bool, float> : public detail::PromoteType<bool, float>
{
    typedef detail::PromoteType<bool, float>::Promote Promote;
    using detail::PromoteType<bool, float>::toPromote;
};

template <>
struct PromoteTraits<bool, double> : public detail::PromoteType<bool, double>
{
    typedef detail::PromoteType<bool, double>::Promote Promote;
    using detail::PromoteType<bool, double>::toPromote;
};

template <>
struct PromoteTraits<bool, long double> : public detail::PromoteType<bool, long double>
{
    typedef detail::PromoteType<bool, long double>::Promote Promote;
    using detail::PromoteType<bool, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<bool, long long> : public detail::PromoteType<bool, long long>
{
    typedef detail::PromoteType<bool, long long>::Promote Promote;
    using detail::PromoteType<bool, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<bool, unsigned long long> : public detail::PromoteType<bool, unsigned long long>
{
    typedef detail::PromoteType<bool, unsigned long long>::Promote Promote;
    using detail::PromoteType<bool, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<signed char, signed char> : public detail::PromoteType<signed char, signed char>
{
    typedef detail::PromoteType<signed char, signed char>::Promote Promote;
    using detail::PromoteType<signed char, signed char>::toPromote;
};

template <>
struct PromoteTraits<signed char, bool> : public detail::PromoteType<signed char, bool>
{
    typedef detail::PromoteType<signed char, bool>::Promote Promote;
    using detail::PromoteType<signed char, bool>::toPromote;
};

template <>
struct PromoteTraits<signed char, unsigned char> : public detail::PromoteType<signed char, unsigned char>
{
    typedef detail::PromoteType<signed char, unsigned char>::Promote Promote;
    using detail::PromoteType<signed char, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<signed char, short> : public detail::PromoteType<signed char, short>
{
    typedef detail::PromoteType<signed char, short>::Promote Promote;
    using detail::PromoteType<signed char, short>::toPromote;
};

template <>
struct PromoteTraits<signed char, unsigned short> : public detail::PromoteType<signed char, unsigned short>
{
    typedef detail::PromoteType<signed char, unsigned short>::Promote Promote;
    using detail::PromoteType<signed char, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<signed char, int> : public detail::PromoteType<signed char, int>
{
    typedef detail::PromoteType<signed char, int>::Promote Promote;
    using detail::PromoteType<signed char, int>::toPromote;
};

template <>
struct PromoteTraits<signed char, unsigned int> : public detail::PromoteType<signed char, unsigned int>
{
    typedef detail::PromoteType<signed char, unsigned int>::Promote Promote;
    using detail::PromoteType<signed char, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<signed char, long> : public detail::PromoteType<signed char, long>
{
    typedef detail::PromoteType<signed char, long>::Promote Promote;
    using detail::PromoteType<signed char, long>::toPromote;
};

template <>
struct PromoteTraits<signed char, unsigned long> : public detail::PromoteType<signed char, unsigned long>
{
    typedef detail::PromoteType<signed char, unsigned long>::Promote Promote;
    using detail::PromoteType<signed char, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<signed char, float> : public detail::PromoteType<signed char, float>
{
    typedef detail::PromoteType<signed char, float>::Promote Promote;
    using detail::PromoteType<signed char, float>::toPromote;
};

template <>
struct PromoteTraits<signed char, double> : public detail::PromoteType<signed char, double>
{
    typedef detail::PromoteType<signed char, double>::Promote Promote;
    using detail::PromoteType<signed char, double>::toPromote;
};

template <>
struct PromoteTraits<signed char, long double> : public detail::PromoteType<signed char, long double>
{
    typedef detail::PromoteType<signed char, long double>::Promote Promote;
    using detail::PromoteType<signed char, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<signed char, long long> : public detail::PromoteType<signed char, long long>
{
    typedef detail::PromoteType<signed char, long long>::Promote Promote;
    using detail::PromoteType<signed char, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<signed char, unsigned long long> : public detail::PromoteType<signed char, unsigned long long>
{
    typedef detail::PromoteType<signed char, unsigned long long>::Promote Promote;
    using detail::PromoteType<signed char, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<unsigned char, unsigned char> : public detail::PromoteType<unsigned char, unsigned char>
{
    typedef detail::PromoteType<unsigned char, unsigned char>::Promote Promote;
    using detail::PromoteType<unsigned char, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, bool> : public detail::PromoteType<unsigned char, bool>
{
    typedef detail::PromoteType<unsigned char, bool>::Promote Promote;
    using detail::PromoteType<unsigned char, bool>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, signed char> : public detail::PromoteType<unsigned char, signed char>
{
    typedef detail::PromoteType<unsigned char, signed char>::Promote Promote;
    using detail::PromoteType<unsigned char, signed char>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, short> : public detail::PromoteType<unsigned char, short>
{
    typedef detail::PromoteType<unsigned char, short>::Promote Promote;
    using detail::PromoteType<unsigned char, short>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, unsigned short> : public detail::PromoteType<unsigned char, unsigned short>
{
    typedef detail::PromoteType<unsigned char, unsigned short>::Promote Promote;
    using detail::PromoteType<unsigned char, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, int> : public detail::PromoteType<unsigned char, int>
{
    typedef detail::PromoteType<unsigned char, int>::Promote Promote;
    using detail::PromoteType<unsigned char, int>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, unsigned int> : public detail::PromoteType<unsigned char, unsigned int>
{
    typedef detail::PromoteType<unsigned char, unsigned int>::Promote Promote;
    using detail::PromoteType<unsigned char, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, long> : public detail::PromoteType<unsigned char, long>
{
    typedef detail::PromoteType<unsigned char, long>::Promote Promote;
    using detail::PromoteType<unsigned char, long>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, unsigned long> : public detail::PromoteType<unsigned char, unsigned long>
{
    typedef detail::PromoteType<unsigned char, unsigned long>::Promote Promote;
    using detail::PromoteType<unsigned char, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, float> : public detail::PromoteType<unsigned char, float>
{
    typedef detail::PromoteType<unsigned char, float>::Promote Promote;
    using detail::PromoteType<unsigned char, float>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, double> : public detail::PromoteType<unsigned char, double>
{
    typedef detail::PromoteType<unsigned char, double>::Promote Promote;
    using detail::PromoteType<unsigned char, double>::toPromote;
};

template <>
struct PromoteTraits<unsigned char, long double> : public detail::PromoteType<unsigned char, long double>
{
    typedef detail::PromoteType<unsigned char, long double>::Promote Promote;
    using detail::PromoteType<unsigned char, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned char, long long> : public detail::PromoteType<unsigned char, long long>
{
    typedef detail::PromoteType<unsigned char, long long>::Promote Promote;
    using detail::PromoteType<unsigned char, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned char, unsigned long long> : public detail::PromoteType<unsigned char, unsigned long long>
{
    typedef detail::PromoteType<unsigned char, unsigned long long>::Promote Promote;
    using detail::PromoteType<unsigned char, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<short, short> : public detail::PromoteType<short, short>
{
    typedef detail::PromoteType<short, short>::Promote Promote;
    using detail::PromoteType<short, short>::toPromote;
};

template <>
struct PromoteTraits<short, bool> : public detail::PromoteType<short, bool>
{
    typedef detail::PromoteType<short, bool>::Promote Promote;
    using detail::PromoteType<short, bool>::toPromote;
};

template <>
struct PromoteTraits<short, signed char> : public detail::PromoteType<short, signed char>
{
    typedef detail::PromoteType<short, signed char>::Promote Promote;
    using detail::PromoteType<short, signed char>::toPromote;
};

template <>
struct PromoteTraits<short, unsigned char> : public detail::PromoteType<short, unsigned char>
{
    typedef detail::PromoteType<short, unsigned char>::Promote Promote;
    using detail::PromoteType<short, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<short, unsigned short> : public detail::PromoteType<short, unsigned short>
{
    typedef detail::PromoteType<short, unsigned short>::Promote Promote;
    using detail::PromoteType<short, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<short, int> : public detail::PromoteType<short, int>
{
    typedef detail::PromoteType<short, int>::Promote Promote;
    using detail::PromoteType<short, int>::toPromote;
};

template <>
struct PromoteTraits<short, unsigned int> : public detail::PromoteType<short, unsigned int>
{
    typedef detail::PromoteType<short, unsigned int>::Promote Promote;
    using detail::PromoteType<short, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<short, long> : public detail::PromoteType<short, long>
{
    typedef detail::PromoteType<short, long>::Promote Promote;
    using detail::PromoteType<short, long>::toPromote;
};

template <>
struct PromoteTraits<short, unsigned long> : public detail::PromoteType<short, unsigned long>
{
    typedef detail::PromoteType<short, unsigned long>::Promote Promote;
    using detail::PromoteType<short, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<short, float> : public detail::PromoteType<short, float>
{
    typedef detail::PromoteType<short, float>::Promote Promote;
    using detail::PromoteType<short, float>::toPromote;
};

template <>
struct PromoteTraits<short, double> : public detail::PromoteType<short, double>
{
    typedef detail::PromoteType<short, double>::Promote Promote;
    using detail::PromoteType<short, double>::toPromote;
};

template <>
struct PromoteTraits<short, long double> : public detail::PromoteType<short, long double>
{
    typedef detail::PromoteType<short, long double>::Promote Promote;
    using detail::PromoteType<short, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<short, long long> : public detail::PromoteType<short, long long>
{
    typedef detail::PromoteType<short, long long>::Promote Promote;
    using detail::PromoteType<short, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<short, unsigned long long> : public detail::PromoteType<short, unsigned long long>
{
    typedef detail::PromoteType<short, unsigned long long>::Promote Promote;
    using detail::PromoteType<short, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<unsigned short, unsigned short> : public detail::PromoteType<unsigned short, unsigned short>
{
    typedef detail::PromoteType<unsigned short, unsigned short>::Promote Promote;
    using detail::PromoteType<unsigned short, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, bool> : public detail::PromoteType<unsigned short, bool>
{
    typedef detail::PromoteType<unsigned short, bool>::Promote Promote;
    using detail::PromoteType<unsigned short, bool>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, signed char> : public detail::PromoteType<unsigned short, signed char>
{
    typedef detail::PromoteType<unsigned short, signed char>::Promote Promote;
    using detail::PromoteType<unsigned short, signed char>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, unsigned char> : public detail::PromoteType<unsigned short, unsigned char>
{
    typedef detail::PromoteType<unsigned short, unsigned char>::Promote Promote;
    using detail::PromoteType<unsigned short, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, short> : public detail::PromoteType<unsigned short, short>
{
    typedef detail::PromoteType<unsigned short, short>::Promote Promote;
    using detail::PromoteType<unsigned short, short>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, int> : public detail::PromoteType<unsigned short, int>
{
    typedef detail::PromoteType<unsigned short, int>::Promote Promote;
    using detail::PromoteType<unsigned short, int>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, unsigned int> : public detail::PromoteType<unsigned short, unsigned int>
{
    typedef detail::PromoteType<unsigned short, unsigned int>::Promote Promote;
    using detail::PromoteType<unsigned short, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, long> : public detail::PromoteType<unsigned short, long>
{
    typedef detail::PromoteType<unsigned short, long>::Promote Promote;
    using detail::PromoteType<unsigned short, long>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, unsigned long> : public detail::PromoteType<unsigned short, unsigned long>
{
    typedef detail::PromoteType<unsigned short, unsigned long>::Promote Promote;
    using detail::PromoteType<unsigned short, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, float> : public detail::PromoteType<unsigned short, float>
{
    typedef detail::PromoteType<unsigned short, float>::Promote Promote;
    using detail::PromoteType<unsigned short, float>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, double> : public detail::PromoteType<unsigned short, double>
{
    typedef detail::PromoteType<unsigned short, double>::Promote Promote;
    using detail::PromoteType<unsigned short, double>::toPromote;
};

template <>
struct PromoteTraits<unsigned short, long double> : public detail::PromoteType<unsigned short, long double>
{
    typedef detail::PromoteType<unsigned short, long double>::Promote Promote;
    using detail::PromoteType<unsigned short, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned short, long long> : public detail::PromoteType<unsigned short, long long>
{
    typedef detail::PromoteType<unsigned short, long long>::Promote Promote;
    using detail::PromoteType<unsigned short, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned short, unsigned long long> : public detail::PromoteType<unsigned short, unsigned long long>
{
    typedef detail::PromoteType<unsigned short, unsigned long long>::Promote Promote;
    using detail::PromoteType<unsigned short, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<int, int> : public detail::PromoteType<int, int>
{
    typedef detail::PromoteType<int, int>::Promote Promote;
    using detail::PromoteType<int, int>::toPromote;
};

template <>
struct PromoteTraits<int, bool> : public detail::PromoteType<int, bool>
{
    typedef detail::PromoteType<int, bool>::Promote Promote;
    using detail::PromoteType<int, bool>::toPromote;
};

template <>
struct PromoteTraits<int, signed char> : public detail::PromoteType<int, signed char>
{
    typedef detail::PromoteType<int, signed char>::Promote Promote;
    using detail::PromoteType<int, signed char>::toPromote;
};

template <>
struct PromoteTraits<int, unsigned char> : public detail::PromoteType<int, unsigned char>
{
    typedef detail::PromoteType<int, unsigned char>::Promote Promote;
    using detail::PromoteType<int, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<int, short> : public detail::PromoteType<int, short>
{
    typedef detail::PromoteType<int, short>::Promote Promote;
    using detail::PromoteType<int, short>::toPromote;
};

template <>
struct PromoteTraits<int, unsigned short> : public detail::PromoteType<int, unsigned short>
{
    typedef detail::PromoteType<int, unsigned short>::Promote Promote;
    using detail::PromoteType<int, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<int, unsigned int> : public detail::PromoteType<int, unsigned int>
{
    typedef detail::PromoteType<int, unsigned int>::Promote Promote;
    using detail::PromoteType<int, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<int, long> : public detail::PromoteType<int, long>
{
    typedef detail::PromoteType<int, long>::Promote Promote;
    using detail::PromoteType<int, long>::toPromote;
};

template <>
struct PromoteTraits<int, unsigned long> : public detail::PromoteType<int, unsigned long>
{
    typedef detail::PromoteType<int, unsigned long>::Promote Promote;
    using detail::PromoteType<int, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<int, float> : public detail::PromoteType<int, float>
{
    typedef detail::PromoteType<int, float>::Promote Promote;
    using detail::PromoteType<int, float>::toPromote;
};

template <>
struct PromoteTraits<int, double> : public detail::PromoteType<int, double>
{
    typedef detail::PromoteType<int, double>::Promote Promote;
    using detail::PromoteType<int, double>::toPromote;
};

template <>
struct PromoteTraits<int, long double> : public detail::PromoteType<int, long double>
{
    typedef detail::PromoteType<int, long double>::Promote Promote;
    using detail::PromoteType<int, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<int, long long> : public detail::PromoteType<int, long long>
{
    typedef detail::PromoteType<int, long long>::Promote Promote;
    using detail::PromoteType<int, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<int, unsigned long long> : public detail::PromoteType<int, unsigned long long>
{
    typedef detail::PromoteType<int, unsigned long long>::Promote Promote;
    using detail::PromoteType<int, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<unsigned int, unsigned int> : public detail::PromoteType<unsigned int, unsigned int>
{
    typedef detail::PromoteType<unsigned int, unsigned int>::Promote Promote;
    using detail::PromoteType<unsigned int, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, bool> : public detail::PromoteType<unsigned int, bool>
{
    typedef detail::PromoteType<unsigned int, bool>::Promote Promote;
    using detail::PromoteType<unsigned int, bool>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, signed char> : public detail::PromoteType<unsigned int, signed char>
{
    typedef detail::PromoteType<unsigned int, signed char>::Promote Promote;
    using detail::PromoteType<unsigned int, signed char>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, unsigned char> : public detail::PromoteType<unsigned int, unsigned char>
{
    typedef detail::PromoteType<unsigned int, unsigned char>::Promote Promote;
    using detail::PromoteType<unsigned int, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, short> : public detail::PromoteType<unsigned int, short>
{
    typedef detail::PromoteType<unsigned int, short>::Promote Promote;
    using detail::PromoteType<unsigned int, short>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, unsigned short> : public detail::PromoteType<unsigned int, unsigned short>
{
    typedef detail::PromoteType<unsigned int, unsigned short>::Promote Promote;
    using detail::PromoteType<unsigned int, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, int> : public detail::PromoteType<unsigned int, int>
{
    typedef detail::PromoteType<unsigned int, int>::Promote Promote;
    using detail::PromoteType<unsigned int, int>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, long> : public detail::PromoteType<unsigned int, long>
{
    typedef detail::PromoteType<unsigned int, long>::Promote Promote;
    using detail::PromoteType<unsigned int, long>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, unsigned long> : public detail::PromoteType<unsigned int, unsigned long>
{
    typedef detail::PromoteType<unsigned int, unsigned long>::Promote Promote;
    using detail::PromoteType<unsigned int, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, float> : public detail::PromoteType<unsigned int, float>
{
    typedef detail::PromoteType<unsigned int, float>::Promote Promote;
    using detail::PromoteType<unsigned int, float>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, double> : public detail::PromoteType<unsigned int, double>
{
    typedef detail::PromoteType<unsigned int, double>::Promote Promote;
    using detail::PromoteType<unsigned int, double>::toPromote;
};

template <>
struct PromoteTraits<unsigned int, long double> : public detail::PromoteType<unsigned int, long double>
{
    typedef detail::PromoteType<unsigned int, long double>::Promote Promote;
    using detail::PromoteType<unsigned int, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned int, long long> : public detail::PromoteType<unsigned int, long long>
{
    typedef detail::PromoteType<unsigned int, long long>::Promote Promote;
    using detail::PromoteType<unsigned int, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned int, unsigned long long> : public detail::PromoteType<unsigned int, unsigned long long>
{
    typedef detail::PromoteType<unsigned int, unsigned long long>::Promote Promote;
    using detail::PromoteType<unsigned int, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<long, long> : public detail::PromoteType<long, long>
{
    typedef detail::PromoteType<long, long>::Promote Promote;
    using detail::PromoteType<long, long>::toPromote;
};

template <>
struct PromoteTraits<long, bool> : public detail::PromoteType<long, bool>
{
    typedef detail::PromoteType<long, bool>::Promote Promote;
    using detail::PromoteType<long, bool>::toPromote;
};

template <>
struct PromoteTraits<long, signed char> : public detail::PromoteType<long, signed char>
{
    typedef detail::PromoteType<long, signed char>::Promote Promote;
    using detail::PromoteType<long, signed char>::toPromote;
};

template <>
struct PromoteTraits<long, unsigned char> : public detail::PromoteType<long, unsigned char>
{
    typedef detail::PromoteType<long, unsigned char>::Promote Promote;
    using detail::PromoteType<long, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<long, short> : public detail::PromoteType<long, short>
{
    typedef detail::PromoteType<long, short>::Promote Promote;
    using detail::PromoteType<long, short>::toPromote;
};

template <>
struct PromoteTraits<long, unsigned short> : public detail::PromoteType<long, unsigned short>
{
    typedef detail::PromoteType<long, unsigned short>::Promote Promote;
    using detail::PromoteType<long, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<long, int> : public detail::PromoteType<long, int>
{
    typedef detail::PromoteType<long, int>::Promote Promote;
    using detail::PromoteType<long, int>::toPromote;
};

template <>
struct PromoteTraits<long, unsigned int> : public detail::PromoteType<long, unsigned int>
{
    typedef detail::PromoteType<long, unsigned int>::Promote Promote;
    using detail::PromoteType<long, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<long, unsigned long> : public detail::PromoteType<long, unsigned long>
{
    typedef detail::PromoteType<long, unsigned long>::Promote Promote;
    using detail::PromoteType<long, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<long, float> : public detail::PromoteType<long, float>
{
    typedef detail::PromoteType<long, float>::Promote Promote;
    using detail::PromoteType<long, float>::toPromote;
};

template <>
struct PromoteTraits<long, double> : public detail::PromoteType<long, double>
{
    typedef detail::PromoteType<long, double>::Promote Promote;
    using detail::PromoteType<long, double>::toPromote;
};

template <>
struct PromoteTraits<long, long double> : public detail::PromoteType<long, long double>
{
    typedef detail::PromoteType<long, long double>::Promote Promote;
    using detail::PromoteType<long, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long, long long> : public detail::PromoteType<long, long long>
{
    typedef detail::PromoteType<long, long long>::Promote Promote;
    using detail::PromoteType<long, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long, unsigned long long> : public detail::PromoteType<long, unsigned long long>
{
    typedef detail::PromoteType<long, unsigned long long>::Promote Promote;
    using detail::PromoteType<long, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<unsigned long, unsigned long> : public detail::PromoteType<unsigned long, unsigned long>
{
    typedef detail::PromoteType<unsigned long, unsigned long>::Promote Promote;
    using detail::PromoteType<unsigned long, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, bool> : public detail::PromoteType<unsigned long, bool>
{
    typedef detail::PromoteType<unsigned long, bool>::Promote Promote;
    using detail::PromoteType<unsigned long, bool>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, signed char> : public detail::PromoteType<unsigned long, signed char>
{
    typedef detail::PromoteType<unsigned long, signed char>::Promote Promote;
    using detail::PromoteType<unsigned long, signed char>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, unsigned char> : public detail::PromoteType<unsigned long, unsigned char>
{
    typedef detail::PromoteType<unsigned long, unsigned char>::Promote Promote;
    using detail::PromoteType<unsigned long, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, short> : public detail::PromoteType<unsigned long, short>
{
    typedef detail::PromoteType<unsigned long, short>::Promote Promote;
    using detail::PromoteType<unsigned long, short>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, unsigned short> : public detail::PromoteType<unsigned long, unsigned short>
{
    typedef detail::PromoteType<unsigned long, unsigned short>::Promote Promote;
    using detail::PromoteType<unsigned long, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, int> : public detail::PromoteType<unsigned long, int>
{
    typedef detail::PromoteType<unsigned long, int>::Promote Promote;
    using detail::PromoteType<unsigned long, int>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, unsigned int> : public detail::PromoteType<unsigned long, unsigned int>
{
    typedef detail::PromoteType<unsigned long, unsigned int>::Promote Promote;
    using detail::PromoteType<unsigned long, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, long> : public detail::PromoteType<unsigned long, long>
{
    typedef detail::PromoteType<unsigned long, long>::Promote Promote;
    using detail::PromoteType<unsigned long, long>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, float> : public detail::PromoteType<unsigned long, float>
{
    typedef detail::PromoteType<unsigned long, float>::Promote Promote;
    using detail::PromoteType<unsigned long, float>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, double> : public detail::PromoteType<unsigned long, double>
{
    typedef detail::PromoteType<unsigned long, double>::Promote Promote;
    using detail::PromoteType<unsigned long, double>::toPromote;
};

template <>
struct PromoteTraits<unsigned long, long double> : public detail::PromoteType<unsigned long, long double>
{
    typedef detail::PromoteType<unsigned long, long double>::Promote Promote;
    using detail::PromoteType<unsigned long, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long, long long> : public detail::PromoteType<unsigned long, long long>
{
    typedef detail::PromoteType<unsigned long, long long>::Promote Promote;
    using detail::PromoteType<unsigned long, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long, unsigned long long> : public detail::PromoteType<unsigned long, unsigned long long>
{
    typedef detail::PromoteType<unsigned long, unsigned long long>::Promote Promote;
    using detail::PromoteType<unsigned long, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<float, float> : public detail::PromoteType<float, float>
{
    typedef detail::PromoteType<float, float>::Promote Promote;
    using detail::PromoteType<float, float>::toPromote;
};

template <>
struct PromoteTraits<float, bool> : public detail::PromoteType<float, bool>
{
    typedef detail::PromoteType<float, bool>::Promote Promote;
    using detail::PromoteType<float, bool>::toPromote;
};

template <>
struct PromoteTraits<float, signed char> : public detail::PromoteType<float, signed char>
{
    typedef detail::PromoteType<float, signed char>::Promote Promote;
    using detail::PromoteType<float, signed char>::toPromote;
};

template <>
struct PromoteTraits<float, unsigned char> : public detail::PromoteType<float, unsigned char>
{
    typedef detail::PromoteType<float, unsigned char>::Promote Promote;
    using detail::PromoteType<float, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<float, short> : public detail::PromoteType<float, short>
{
    typedef detail::PromoteType<float, short>::Promote Promote;
    using detail::PromoteType<float, short>::toPromote;
};

template <>
struct PromoteTraits<float, unsigned short> : public detail::PromoteType<float, unsigned short>
{
    typedef detail::PromoteType<float, unsigned short>::Promote Promote;
    using detail::PromoteType<float, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<float, int> : public detail::PromoteType<float, int>
{
    typedef detail::PromoteType<float, int>::Promote Promote;
    using detail::PromoteType<float, int>::toPromote;
};

template <>
struct PromoteTraits<float, unsigned int> : public detail::PromoteType<float, unsigned int>
{
    typedef detail::PromoteType<float, unsigned int>::Promote Promote;
    using detail::PromoteType<float, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<float, long> : public detail::PromoteType<float, long>
{
    typedef detail::PromoteType<float, long>::Promote Promote;
    using detail::PromoteType<float, long>::toPromote;
};

template <>
struct PromoteTraits<float, unsigned long> : public detail::PromoteType<float, unsigned long>
{
    typedef detail::PromoteType<float, unsigned long>::Promote Promote;
    using detail::PromoteType<float, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<float, double> : public detail::PromoteType<float, double>
{
    typedef detail::PromoteType<float, double>::Promote Promote;
    using detail::PromoteType<float, double>::toPromote;
};

template <>
struct PromoteTraits<float, long double> : public detail::PromoteType<float, long double>
{
    typedef detail::PromoteType<float, long double>::Promote Promote;
    using detail::PromoteType<float, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<float, long long> : public detail::PromoteType<float, long long>
{
    typedef detail::PromoteType<float, long long>::Promote Promote;
    using detail::PromoteType<float, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<float, unsigned long long> : public detail::PromoteType<float, unsigned long long>
{
    typedef detail::PromoteType<float, unsigned long long>::Promote Promote;
    using detail::PromoteType<float, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<double, double> : public detail::PromoteType<double, double>
{
    typedef detail::PromoteType<double, double>::Promote Promote;
    using detail::PromoteType<double, double>::toPromote;
};

template <>
struct PromoteTraits<double, bool> : public detail::PromoteType<double, bool>
{
    typedef detail::PromoteType<double, bool>::Promote Promote;
    using detail::PromoteType<double, bool>::toPromote;
};

template <>
struct PromoteTraits<double, signed char> : public detail::PromoteType<double, signed char>
{
    typedef detail::PromoteType<double, signed char>::Promote Promote;
    using detail::PromoteType<double, signed char>::toPromote;
};

template <>
struct PromoteTraits<double, unsigned char> : public detail::PromoteType<double, unsigned char>
{
    typedef detail::PromoteType<double, unsigned char>::Promote Promote;
    using detail::PromoteType<double, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<double, short> : public detail::PromoteType<double, short>
{
    typedef detail::PromoteType<double, short>::Promote Promote;
    using detail::PromoteType<double, short>::toPromote;
};

template <>
struct PromoteTraits<double, unsigned short> : public detail::PromoteType<double, unsigned short>
{
    typedef detail::PromoteType<double, unsigned short>::Promote Promote;
    using detail::PromoteType<double, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<double, int> : public detail::PromoteType<double, int>
{
    typedef detail::PromoteType<double, int>::Promote Promote;
    using detail::PromoteType<double, int>::toPromote;
};

template <>
struct PromoteTraits<double, unsigned int> : public detail::PromoteType<double, unsigned int>
{
    typedef detail::PromoteType<double, unsigned int>::Promote Promote;
    using detail::PromoteType<double, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<double, long> : public detail::PromoteType<double, long>
{
    typedef detail::PromoteType<double, long>::Promote Promote;
    using detail::PromoteType<double, long>::toPromote;
};

template <>
struct PromoteTraits<double, unsigned long> : public detail::PromoteType<double, unsigned long>
{
    typedef detail::PromoteType<double, unsigned long>::Promote Promote;
    using detail::PromoteType<double, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<double, float> : public detail::PromoteType<double, float>
{
    typedef detail::PromoteType<double, float>::Promote Promote;
    using detail::PromoteType<double, float>::toPromote;
};

template <>
struct PromoteTraits<double, long double> : public detail::PromoteType<double, long double>
{
    typedef detail::PromoteType<double, long double>::Promote Promote;
    using detail::PromoteType<double, long double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<double, long long> : public detail::PromoteType<double, long long>
{
    typedef detail::PromoteType<double, long long>::Promote Promote;
    using detail::PromoteType<double, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<double, unsigned long long> : public detail::PromoteType<double, unsigned long long>
{
    typedef detail::PromoteType<double, unsigned long long>::Promote Promote;
    using detail::PromoteType<double, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

template <>
struct PromoteTraits<long double, long double> : public detail::PromoteType<long double, long double>
{
    typedef detail::PromoteType<long double, long double>::Promote Promote;
    using detail::PromoteType<long double, long double>::toPromote;
};

template <>
struct PromoteTraits<long double, bool> : public detail::PromoteType<long double, bool>
{
    typedef detail::PromoteType<long double, bool>::Promote Promote;
    using detail::PromoteType<long double, bool>::toPromote;
};

template <>
struct PromoteTraits<long double, signed char> : public detail::PromoteType<long double, signed char>
{
    typedef detail::PromoteType<long double, signed char>::Promote Promote;
    using detail::PromoteType<long double, signed char>::toPromote;
};

template <>
struct PromoteTraits<long double, unsigned char> : public detail::PromoteType<long double, unsigned char>
{
    typedef detail::PromoteType<long double, unsigned char>::Promote Promote;
    using detail::PromoteType<long double, unsigned char>::toPromote;
};

template <>
struct PromoteTraits<long double, short> : public detail::PromoteType<long double, short>
{
    typedef detail::PromoteType<long double, short>::Promote Promote;
    using detail::PromoteType<long double, short>::toPromote;
};

template <>
struct PromoteTraits<long double, unsigned short> : public detail::PromoteType<long double, unsigned short>
{
    typedef detail::PromoteType<long double, unsigned short>::Promote Promote;
    using detail::PromoteType<long double, unsigned short>::toPromote;
};

template <>
struct PromoteTraits<long double, int> : public detail::PromoteType<long double, int>
{
    typedef detail::PromoteType<long double, int>::Promote Promote;
    using detail::PromoteType<long double, int>::toPromote;
};

template <>
struct PromoteTraits<long double, unsigned int> : public detail::PromoteType<long double, unsigned int>
{
    typedef detail::PromoteType<long double, unsigned int>::Promote Promote;
    using detail::PromoteType<long double, unsigned int>::toPromote;
};

template <>
struct PromoteTraits<long double, long> : public detail::PromoteType<long double, long>
{
    typedef detail::PromoteType<long double, long>::Promote Promote;
    using detail::PromoteType<long double, long>::toPromote;
};

template <>
struct PromoteTraits<long double, unsigned long> : public detail::PromoteType<long double, unsigned long>
{
    typedef detail::PromoteType<long double, unsigned long>::Promote Promote;
    using detail::PromoteType<long double, unsigned long>::toPromote;
};

template <>
struct PromoteTraits<long double, float> : public detail::PromoteType<long double, float>
{
    typedef detail::PromoteType<long double, float>::Promote Promote;
    using detail::PromoteType<long double, float>::toPromote;
};

template <>
struct PromoteTraits<long double, double> : public detail::PromoteType<long double, double>
{
    typedef detail::PromoteType<long double, double>::Promote Promote;
    using detail::PromoteType<long double, double>::toPromote;
};

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long double, long long> : public detail::PromoteType<long double, long long>
{
    typedef detail::PromoteType<long double, long long>::Promote Promote;
    using detail::PromoteType<long double, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long double, unsigned long long> : public detail::PromoteType<long double, unsigned long long>
{
    typedef detail::PromoteType<long double, unsigned long long>::Promote Promote;
    using detail::PromoteType<long double, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, long long> : public detail::PromoteType<long long, long long>
{
    typedef detail::PromoteType<long long, long long>::Promote Promote;
    using detail::PromoteType<long long, long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, bool> : public detail::PromoteType<long long, bool>
{
    typedef detail::PromoteType<long long, bool>::Promote Promote;
    using detail::PromoteType<long long, bool>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, signed char> : public detail::PromoteType<long long, signed char>
{
    typedef detail::PromoteType<long long, signed char>::Promote Promote;
    using detail::PromoteType<long long, signed char>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, unsigned char> : public detail::PromoteType<long long, unsigned char>
{
    typedef detail::PromoteType<long long, unsigned char>::Promote Promote;
    using detail::PromoteType<long long, unsigned char>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, short> : public detail::PromoteType<long long, short>
{
    typedef detail::PromoteType<long long, short>::Promote Promote;
    using detail::PromoteType<long long, short>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, unsigned short> : public detail::PromoteType<long long, unsigned short>
{
    typedef detail::PromoteType<long long, unsigned short>::Promote Promote;
    using detail::PromoteType<long long, unsigned short>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, int> : public detail::PromoteType<long long, int>
{
    typedef detail::PromoteType<long long, int>::Promote Promote;
    using detail::PromoteType<long long, int>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, unsigned int> : public detail::PromoteType<long long, unsigned int>
{
    typedef detail::PromoteType<long long, unsigned int>::Promote Promote;
    using detail::PromoteType<long long, unsigned int>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, long> : public detail::PromoteType<long long, long>
{
    typedef detail::PromoteType<long long, long>::Promote Promote;
    using detail::PromoteType<long long, long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, unsigned long> : public detail::PromoteType<long long, unsigned long>
{
    typedef detail::PromoteType<long long, unsigned long>::Promote Promote;
    using detail::PromoteType<long long, unsigned long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, float> : public detail::PromoteType<long long, float>
{
    typedef detail::PromoteType<long long, float>::Promote Promote;
    using detail::PromoteType<long long, float>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, double> : public detail::PromoteType<long long, double>
{
    typedef detail::PromoteType<long long, double>::Promote Promote;
    using detail::PromoteType<long long, double>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, long double> : public detail::PromoteType<long long, long double>
{
    typedef detail::PromoteType<long long, long double>::Promote Promote;
    using detail::PromoteType<long long, long double>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<long long, unsigned long long> : public detail::PromoteType<long long, unsigned long long>
{
    typedef detail::PromoteType<long long, unsigned long long>::Promote Promote;
    using detail::PromoteType<long long, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, unsigned long long> : public detail::PromoteType<unsigned long long, unsigned long long>
{
    typedef detail::PromoteType<unsigned long long, unsigned long long>::Promote Promote;
    using detail::PromoteType<unsigned long long, unsigned long long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, bool> : public detail::PromoteType<unsigned long long, bool>
{
    typedef detail::PromoteType<unsigned long long, bool>::Promote Promote;
    using detail::PromoteType<unsigned long long, bool>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, signed char> : public detail::PromoteType<unsigned long long, signed char>
{
    typedef detail::PromoteType<unsigned long long, signed char>::Promote Promote;
    using detail::PromoteType<unsigned long long, signed char>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, unsigned char> : public detail::PromoteType<unsigned long long, unsigned char>
{
    typedef detail::PromoteType<unsigned long long, unsigned char>::Promote Promote;
    using detail::PromoteType<unsigned long long, unsigned char>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, short> : public detail::PromoteType<unsigned long long, short>
{
    typedef detail::PromoteType<unsigned long long, short>::Promote Promote;
    using detail::PromoteType<unsigned long long, short>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, unsigned short> : public detail::PromoteType<unsigned long long, unsigned short>
{
    typedef detail::PromoteType<unsigned long long, unsigned short>::Promote Promote;
    using detail::PromoteType<unsigned long long, unsigned short>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, int> : public detail::PromoteType<unsigned long long, int>
{
    typedef detail::PromoteType<unsigned long long, int>::Promote Promote;
    using detail::PromoteType<unsigned long long, int>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, unsigned int> : public detail::PromoteType<unsigned long long, unsigned int>
{
    typedef detail::PromoteType<unsigned long long, unsigned int>::Promote Promote;
    using detail::PromoteType<unsigned long long, unsigned int>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, long> : public detail::PromoteType<unsigned long long, long>
{
    typedef detail::PromoteType<unsigned long long, long>::Promote Promote;
    using detail::PromoteType<unsigned long long, long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, unsigned long> : public detail::PromoteType<unsigned long long, unsigned long>
{
    typedef detail::PromoteType<unsigned long long, unsigned long>::Promote Promote;
    using detail::PromoteType<unsigned long long, unsigned long>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, float> : public detail::PromoteType<unsigned long long, float>
{
    typedef detail::PromoteType<unsigned long long, float>::Promote Promote;
    using detail::PromoteType<unsigned long long, float>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, double> : public detail::PromoteType<unsigned long long, double>
{
    typedef detail::PromoteType<unsigned long long, double>::Promote Promote;
    using detail::PromoteType<unsigned long long, double>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, long double> : public detail::PromoteType<unsigned long long, long double>
{
    typedef detail::PromoteType<unsigned long long, long double>::Promote Promote;
    using detail::PromoteType<unsigned long long, long double>::toPromote;
};
#endif // LLONG_MAX

#ifdef LLONG_MAX
template <>
struct PromoteTraits<unsigned long long, long long> : public detail::PromoteType<unsigned long long, long long>
{
    typedef detail::PromoteType<unsigned long long, long long>::Promote Promote;
    using detail::PromoteType<unsigned long long, long long>::toPromote;
};
#endif // LLONG_MAX



#endif // VIGRA_PROMOTETRAITS_HXX
