/*
 * Decompiled with CFR 0.152.
 */
package hughai.unitdata;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.PlayerObjects;
import hughai.ResourceManager;
import hughai.utils.LogFile;

public class UnitDefHelp {
    OOAICallback aicallback;
    ResourceManager resourceManager;
    LogFile logfile;

    public UnitDefHelp(PlayerObjects playerObjects) {
        this.aicallback = playerObjects.getAicallback();
        this.resourceManager = playerObjects.getResourceManager();
        this.logfile = playerObjects.getLogFile();
    }

    public boolean IsEnergy(UnitDef unitDef) {
        if (unitDef.isNeedGeo()) {
            return false;
        }
        if (unitDef.getUpkeep(this.resourceManager.getEnergyResource()) < -1.0f) {
            return true;
        }
        if (unitDef.getWindResourceGenerator(this.resourceManager.getEnergyResource()) > 0.0f && this.aicallback.getMap().getMaxWind() > 9.0f) {
            return true;
        }
        if (unitDef.getTidalResourceGenerator(this.resourceManager.getEnergyResource()) > 0.0f) {
            return true;
        }
        return unitDef.getMakesResource(this.resourceManager.getEnergyResource()) > 5.0f;
    }

    public boolean IsMobile(UnitDef unitDef) {
        if (unitDef.getSpeed() < 1.0f) {
            return false;
        }
        if (unitDef.getMoveData() != null) {
            return true;
        }
        return unitDef.isAbleToFly();
    }

    public boolean IsBoat(UnitDef unitDef) {
        return this.IsMobile(unitDef) && unitDef.getMinWaterDepth() > 0.0f;
    }

    public boolean IsConstructor(UnitDef unitDef) {
        if (unitDef.getBuildOptions().size() == 0) {
            return false;
        }
        return unitDef.isBuilder() && this.IsMobile(unitDef);
    }

    public boolean IsFactory(UnitDef unitDef) {
        if (unitDef.getBuildOptions().size() == 0) {
            return false;
        }
        return unitDef.isBuilder() && !this.IsMobile(unitDef);
    }

    public boolean IsGroundMelee(UnitDef unitDef) {
        return this.IsMobile(unitDef) && unitDef.isAbleToAttack();
    }

    public boolean IsMex(UnitDef unitDef) {
        return unitDef.getExtractsResource(this.resourceManager.getMetalResource()) > 0.0f;
    }

    public boolean IsAirCraft(UnitDef unitDef) {
        return unitDef.isAbleToFly() && unitDef.getMoveData() == null;
    }

    public boolean IsGunship(UnitDef unitDef) {
        return this.IsAirCraft(unitDef) && unitDef.isHoverAttack();
    }

    public boolean IsFighter(UnitDef unitDef) {
        return this.IsAirCraft(unitDef) && !unitDef.isHoverAttack();
    }

    public boolean IsBomber(UnitDef unitDef) {
        if (this.IsAirCraft(unitDef)) {
            // empty if block
        }
        return false;
    }
}

